#version 120
#pragma optionNV unroll all
#define MAX_LIGHTS 14
#define MAX_BONES 78

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];

varying vec3 alightVec[MAX_LIGHTS];

varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];

uniform vec4 glColor;
uniform vec3 camPos;

    varying vec3 v;
    varying vec3 vcam;
    varying vec4 vcam4;
    varying vec3 N;
    varying vec3 T;
    varying vec3 B;





vec3 tmpVec;


void main(void)
{
vec4 vP;
vec4 vN;
vec4 vT;
	
	
	
	vP=vec4(vertexPosition.xyz, 1.0);
	vN=vec4(vertexNormal.xyz, 1.0);
	vT=vec4(vertexTangent.xyz, 1.0);
    

    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0); 

    texCoord = textureCoord;

	
	vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
	vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
	
	
	
	


	vec3 b = cross(n, t) * vertexTangentHandedness;
    
	
	

	
	vec3 vVertex = (gl_ModelViewMatrix * vec4(vP.xyz, 1.0)).xyz;

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	
    tmpVec = vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;



	}
   }

   
   
    v=vVertex;
    vcam=(gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0)).xyz;
    vcam4=(gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0));
    N=normalize(n);
    T=normalize(t);
    B=normalize(b);
    }
